    %Dtag components in the sand box
function drag_component_in_sand_box(fig_handle, ~ , system)
% function drag_and_drop should be attached to WindowButtonMotionFcn
handles = guihandles(fig_handle);
% get position information of the sand box
[lx_sb,ly_sb,lw_sb,lh_sb] = get_positon(handles.Sand_box);
[lx_sy,ly_sy,lw_sy,lh_sy] = get_positon(handles.System_panel);
pos = get(fig_handle, 'currentpoint');  % get mouse location on figure
x = pos(1); y = pos(2);                 % assign locations to x and y

%% Create a list of the components in the sand box
number_of_handles = 37; 
list_of_components = handles.Drag_and_drop_tab.Children(1:length(handles.Drag_and_drop_tab.Children)-number_of_handles);
for i =1:length(list_of_components)
    lx = list_of_components(i).Position(1); ly = list_of_components(i).Position(2);
    lw = list_of_components(i).Position(3); lh = list_of_components(i).Position(4);
    %set grab function when the user stand on one o fthe componennts in the sand box
    if x >= lx && x <= (lx + lw) && y >= ly && y <= (ly + lh)
        %uistack(list_of_components(i),'top');
        %setfigptr('hand', handles.fig_mouse);
        setfigptr('hand', fig_handle);
        current_object = list_of_components(i);
        set(current_object, 'ButtonPushedFcn', @grab);
%         disp('x: ');
%         disp(x);
%         disp('y: ');
%         disp(y);
%         disp(current_object.Text)
%         break
    else
        setfigptr('arrow', fig_handle);
%         disp('x: ');
%         disp(x);
%         disp('y: ');
%         disp(y);
%         disp('None');
    end
end

    function grab(~, ~)
        % change the shape of the pointer to closed hand
        % computing x, y difference between pointer and uicontrol 
        % so that the movement can be in sync
        mouse_pos = get(fig_handle, 'currentpoint'); 
        target_pos = get(current_object,'position');
        last_pos = get(fig_handle, 'currentpoint');
        dx = mouse_pos(1) - target_pos(1);
        dy = mouse_pos(2) - target_pos(2);
        % attach drag and release to WindowButtonMotionFcn and
        % WindowButtonUpFcn
        set(fig_handle,'WindowButtonMotionFcn', @drag);   
        set(current_object,'ButtonPushedFcn',@release);
        setfigptr('closedhand', fig_handle);
        
        function drag(~, ~)
            % to be attached to WindowButtonMotionFcn
            % get mouse x,y location on figure
            mouse_pos = get(fig_handle, 'currentpoint'); 
            x = mouse_pos(1); y = mouse_pos(2);      
            % get position information of the uicontrol system

            
            if x >= lx_sb && x <= (lx_sb + lw_sb) && y >= ly_sb && y <= (ly_sb + lh_sb) %realese in sand box
                %% Drag component in sand box 
                %setfigptr('closedhand', fig_handle);
            elseif x >= lx_sy && x <= (lx_sy + lw_sy) && y >= ly_sy && y <= (ly_sy + lh_sy) % release in system panel
                %% Drag component in system panel
                %setfigptr('ddrag', fig_handle);       
            else
                %% Drag component in any other place
                %setfigptr('eraser', fig_handle);
            end
                
            % get uicontrol width and height
            target_pos = get(current_object,'position');
            tw = target_pos(3); th = target_pos(4);
            % update uicontrol position based on the computed x,y locations
            target_pos = [x-dx, y-dy, tw, th];
            set(current_object,'position', target_pos);
            
        end
        
        function release(~, ~)
            % to be attached to WindowButtonUpFcn
            % update pointer back to hand shape 
            setfigptr('hand', fig_handle);

            mouse_pos = get(fig_handle, 'currentpoint'); 
            x = mouse_pos(1); y = mouse_pos(2);            
            
            % get position information of the uicontrol system
            
            if x >= lx_sb && x <= (lx_sb + lw_sb) && y >= ly_sb && y <= (ly_sb + lh_sb)% release in sand box
                %% Release component in sand box
                set(current_object,'ButtonPushedFcn', '');
            elseif x >= lx_sy && x <= (lx_sy + lw_sy) && y >= ly_sy && y <= (ly_sy + lh_sy) % release in system panel
                %% Release component in system panel
                set(current_object,'ButtonPushedFcn', '');
            else 
                %% Release component in other areas
            set(fig_handle, 'WindowButtonMotionFcn', {@drag_and_drop_M,system});
            selection = uiconfirm(fig_handle,'Are you Sure you want to delete this item?','Confirm deletion',...
                    'Icon','warning');
            % Handle response
            switch selection
                case 'OK'
                    %% delete compoenent
                    Data_Table = fig_handle.RunningAppInstance.Data_table;
                    Deleted_component = current_object.Tag;
                    for j =1:15
                        if isempty(Data_Table{j})
                            continue
                        end
                       current_type =  Data_Table{j}(:,1);
                       loc_component = find(strcmp(current_type,Deleted_component));
                       if isempty(loc_component)
                           continue
                       else
                           fig_handle.RunningAppInstance.Data_table{j}(loc_component,:) = [];
                           Data_Table{j}(loc_component,:) = [];
                           handles.Compliance_table.Data = Data_Table{1};
                           handles.Target_Jacket_table.Data = Data_Table{2};
                           handles.Round_Duct_table.Data = Data_Table{3};
                           break
                       end
                    end
                    delete(current_object.ContextMenu);
                    delete(current_object); 
                    %% cancel deletion
                case 'Cancel'
                    set(current_object, 'position' ,[last_pos,current_object.Position(3:4)]);
            end
                %erase the component
            setfigptr('arrow', fig_handle);
            end
            arrangment_components_in_system_panel(fig_handle,system);
            set(fig_handle, 'WindowButtonMotionFcn', {@drag_and_drop_M,system});
        end % end of release function 
        
    end % end of grab function 
    set(fig_handle, 'WindowButtonMotionFcn', {@drag_and_drop_M,system});
end